/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2586;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.internal.block.StaticBlockComponentPlugin;

public final class CardinalBlockInternals {
    private static final Map<Class<? extends class_2586>, ComponentContainer.Factory<class_2586>> entityContainerFactories = new HashMap<Class<? extends class_2586>, ComponentContainer.Factory<class_2586>>();

    public static ComponentContainer createComponents(class_2586 blockEntity) {
        Class<?> entityClass = blockEntity.getClass();
        ComponentContainer.Factory<class_2586> existing = entityContainerFactories.get(entityClass);
        return Objects.requireNonNullElseGet(existing, () -> CardinalBlockInternals.getBeComponentFactory(entityClass)).createContainer((Object)blockEntity);
    }

    private static synchronized ComponentContainer.Factory<class_2586> getBeComponentFactory(Class<? extends class_2586> entityClass) {
        ComponentContainer.Factory<class_2586> factory;
        ComponentContainer.Factory<class_2586> existing = entityContainerFactories.get(entityClass);
        if (existing != null) {
            return existing;
        }
        if (StaticBlockComponentPlugin.INSTANCE.requiresStaticFactory(entityClass)) {
            factory = StaticBlockComponentPlugin.INSTANCE.buildDedicatedFactory(entityClass);
        } else {
            Class<? extends class_2586> superclass = entityClass.getSuperclass();
            assert (class_2586.class.isAssignableFrom(superclass)) : "requiresStaticFactory returned false on BlockEntity?";
            factory = CardinalBlockInternals.getBeComponentFactory(superclass);
        }
        entityContainerFactories.put(entityClass, factory);
        return factory;
    }
}

