/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.base;

import java.util.Iterator;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentContainer;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.CopyableComponent;
import org.ladysnake.cca.api.v3.component.TransientComponent;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.mixin.base.NbtReadViewAccessor;

public abstract class AbstractComponentContainer
implements ComponentContainer {
    public static final String NBT_KEY = "cardinal_components";

    @Override
    public void copyFrom(ComponentContainer other, class_7225.class_7874 registryLookup) {
        for (ComponentKey<?> key : this.keys()) {
            Object theirs = key.getInternal(other);
            Object ours = key.getInternal(this);
            assert (ours != null);
            if (theirs == null || ours.equals(theirs)) continue;
            if (ours instanceof CopyableComponent) {
                CopyableComponent copyable = (CopyableComponent)ours;
                copyable.copyFrom(theirs, registryLookup);
                continue;
            }
            try (class_8942.class_11340 errorReporter = new class_8942.class_11340(ComponentsInternals.LOGGER);){
                class_11362 writeView = class_11362.method_71459((class_8942)errorReporter, (class_7225.class_7874)registryLookup);
                theirs.writeData((class_11372)writeView);
                ours.readData(class_11352.method_71417((class_8942)errorReporter, (class_7225.class_7874)registryLookup, (class_2487)writeView.method_71475()));
            }
        }
    }

    @Override
    public void readData(class_11368 readView) {
        this.readOrphanData(readView.method_71434(NBT_KEY));
    }

    @Override
    public void readOrphanData(class_11368 componentMap) {
        class_2487 class_24872;
        if (componentMap instanceof NbtReadViewAccessor) {
            NbtReadViewAccessor nbtReadView = (NbtReadViewAccessor)componentMap;
            class_24872 = nbtReadView.getNbt();
        } else {
            class_24872 = null;
        }
        class_2487 underlyingNbt = class_24872;
        for (ComponentKey<?> key : this.keys()) {
            String keyId = key.getId().toString();
            class_11368 componentData = componentMap.method_71434(keyId);
            Object component = key.getInternal(this);
            assert (component != null);
            component.readData(componentData);
            if (underlyingNbt == null) continue;
            underlyingNbt.method_10551(keyId);
        }
        if (underlyingNbt != null) {
            ComponentsInternals.logDeserializationWarnings(underlyingNbt.method_10541());
        }
    }

    @Override
    public void writeData(class_11372 writeView) {
        if (this.hasComponents()) {
            this.writeOrphanData(writeView.method_71461(NBT_KEY));
        }
    }

    @Override
    public void writeOrphanData(class_11372 writeView) {
        for (ComponentKey<?> type : this.keys()) {
            Object component = type.getFromContainer(this);
            if (component instanceof TransientComponent) continue;
            component.writeData(writeView.method_71461(type.getId().toString()));
        }
    }

    @Override
    @Nullable
    public class_2487 toOrphanTag(class_7225.class_7874 registryLookup) {
        try (class_8942.class_11340 errorReporter = new class_8942.class_11340(ComponentsInternals.LOGGER);){
            class_11362 writeView = class_11362.method_71459((class_8942)errorReporter, (class_7225.class_7874)registryLookup);
            this.writeOrphanData((class_11372)writeView);
            class_2487 class_24872 = writeView.method_71457() ? null : writeView.method_71475();
            return class_24872;
        }
    }

    public String toString() {
        Iterator<ComponentKey<?>> i = this.keys().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            ComponentKey<?> key = i.next();
            Object value = key.getInternal(this);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

